
// SINUS.CPP
// Zeichnet den Graphen der Sinusfunktion

#include <champ.h>
#include "sinus.rh"

const double XMIN = -0.1;
const double XMAX = 6.5;
const double YMIN = -1.1;
const double YMAX = 1.1;

void zeichneKoordinatensystem ();

void gmain ()
{
   double dx;                                // Schrittweite in for-Schleife
   double y;                                 // y = sin( x );

   ginit( "Sinusfunktion", CP::WinBigSq );   // Graphik in einem grossen
   gwindowEven( XMIN, XMAX, YMIN, YMAX );    // Graphikfenster
   dx = ( XMAX - XMIN ) / gwidth();

   zeichneKoordinatensystem();

   y = sin( XMIN );
   gpos( XMIN, y );
   gputPixel( XMIN, y, BLACK );              // Setze einen schwarzen Punkt

   for ( double x = XMIN; x <= XMAX; x = x + dx )
   {
      y = sin( x );
      gdraw( x, y );
   }

   CP::msgBoxD();
   gend();
}

void zeichneKoordinatensystem ()             // Zeichnet Koordinatensystem
{
   gline( XMIN, 0, XMAX, 0 );
   gline( 0, YMIN, 0, YMAX );
   for ( int x = ceil( XMIN ); x <= XMAX; x++ )
   {
      gline( x, -0.05, x, 0.05 );            // Beschriften der x-Achse
      gtext( x, -0.2 ) << x;
   }
   for ( int y = ceil( YMIN ); y <= YMAX; y++ )
   {
      gline( -0.05, y, 0.05, y );            // Beschriften der y-Achse
      if ( y != 0 )                          // Der Ursprung soll nicht zweimal
         gtext( 0.05, y ) << y;              // angeschrieben werden!
   }

   gpos( 3, 2 );
   gtextFont( "Times New Roman", 0.5 );      // Schriftart und -hoehe
   gtextItalic();                            // Umschalten auf Kursivschrift
   gtext() << "f(x) = ";
   gtextItalic( false );                     // Umschalten auf Normalschrift
   gtext() << "sin ";
   gtextItalic();
   gtext() << "x";
}
