
// WUERFEL.CPP
// Simuliert einen Wuerfel

#include <champ.h>
#include <stdlib.h>                        // Noetig, damit die Befehle random()
#include "wuerfel.rh"                      // und randomize() verstanden werden.

void relativeHaeufigkeiten ( const int anzahl[], double rel[] );

const int ANZAHLWUERFE = 100;              // Anzahl der Wuerfe

void gmain ()
{
   int anzahl[ 6 ] = { 0, 0, 0, 0, 0, 0 }; // Array fuer die Augenzahlen
   double rel[ 6 ];                        // Array fuer die relative Haeufigkeit
   int wurf;                               // Augenzahl des aktuellen Wurfes
   int i;                                  // Zaehlvariable

   cinit( "Wuerfelsimulator" );
   randomize();

   for ( i = 1; i <= ANZAHLWUERFE; i++)    // Simulation der Wuerfe
   {
      wurf = random( 6 );
      anzahl[ wurf ]++;                    // entspricht dem Befehl
   }                                       // anzahl[ wurf ] = anzahl[ wurf ] + 1;

   relativeHaeufigkeiten( anzahl, rel );   // Berechnung der relativen
                                           // Haeufigkeiten

   cout << "Augenzahl:  abs. Haeufigkeit:  rel. Haeufigkeit: \n";
   for ( i = 0; i <= 5; i++)
      cout << ( i + 1 ) << "\t\t" << anzahl[ i ] << "\t\t   " << rel[ i ] << "\n";

   CP::msgBoxD();
   cend();
}

void relativeHaeufigkeiten ( const int anzahl[], double rel[] )
{
   for ( int i = 0; i <= 5; i++ )
      rel[ i ] = ( double ) anzahl[ i ] / ANZAHLWUERFE;
}
