
// AUSGABE1.CPP
// Dieses Programm zeigt verschiedene Formen von formatierter Ausgabe.

#include <champ.h>
#include "ausgabe1.rh"

void ausgabe ( double piDouble, float piFloat, double a, double b,
               double c, double d, int e );

void gmain ()
{
   double piDouble = 3.141592653589793;          // "genaues" PI
   float piFloat = 3.141592;                     // "ungenaues" PI
   double a = 2.0 / 3.0;
   double b = 8.0 / 3.0;
   double c = 9.0 / 3.0;
   double d = 7.0 / 4.0;
   int e = 6 / 3;

   cinit( "Formatierte Ausgabe" );

   cout << "Unformatierte Ausgabe: \n";
   ausgabe( piDouble, piFloat, a, b, c, d, e );

   cout << "Auf 4 wesentliche Stellen genau (ohne fixed/showpoint): \n";
   cout << setprecision( 4 );
   ausgabe( piDouble, piFloat, a, b, c, d, e );

   cout << "Auf 4 wesentliche Stellen genau (mit showpoint): \n";
   cout << setiosflags( ios::showpoint ) << setprecision( 4 );
   ausgabe( piDouble, piFloat, a, b, c, d, e );
   cout << resetiosflags( ios::showpoint );

   cout << "Auf 4 Nachkommastellen genau (mit fixed): \n";
   cout << setiosflags( ios::fixed );
   ausgabe( piDouble, piFloat, a, b, c, d, e );

   cout << "Auf 10 Nachkommastellen genau: \n";
   cout << setprecision( 10 );
   ausgabe( piDouble, piFloat, a, b, c, d, e );

   cout << "Auf 10 wesentliche Stellen genau: \n";
   cout << resetiosflags( ios::fixed );
   ausgabe( piDouble, piFloat, a, b, c, d, e );

   cout << "Wissenschaftliche Schreibweise: \n";
   cout << setiosflags( ios::scientific );
   ausgabe( piDouble, piFloat, a, b, c, d, e );

   cout << "Zurueckschalten in Normalschreibweise: \n";
   cout << resetiosflags( ios::scientific );
   ausgabe( piDouble, piFloat, a, b, c, d, e );

   CP::msgBoxD();
   cend();
}

void ausgabe ( double piDouble, float piFloat, double a, double b,
               double c, double d, int e )
{
   cout << "PI1 = " << piDouble << "\n";
   cout << "PI2 = " << piFloat << "\n";
   cout << "2/3 = " << a << "\n";
   cout << "8/3 = " << b << "\n";
   cout << "9/3 = " << c << "\n";
   cout << "7/4 = " << d << "\n";
   cout << "6/3 = " << e << "\n\n";
}
