
// KLASSEN3.CPP
// Erzeugt wird eine Klasse Fenster, abgeleitet von der Klasse CPWindow.
// Die Klasse erhaelt einen eigenen Konstruktor und private Variablen (Attribute).

#include <champ.h>
#include "klassen3.rh"


const double XMIN = -0.1;

const double XMAX = 6.5;
const double YMIN = -1.1;
const double YMAX = 1.1;


class Fenster : public CPWindow

{

   public :

      Fenster ( char titel[],

                double xmin,

                double xmax,

                double ymin,

                double ymax );

      void zeichneKoordinatensystem ();


   private :

      double _xmin, _xmax, _ymin, _ymax; // Private Variablen (Attribute) der

};                                       // Klasse Fenster


Fenster::Fenster ( char titel[],

                   double xmin,

                   double xmax,

                   double ymin,

                   double ymax  ) : CPWindow( titel )

{

   _xmin = xmin;                         // Initialisierung der Attribute

   _xmax = xmax;

   _ymin = ymin;

   _ymax = ymax;

   windowEven( _xmin, _xmax, _ymin, _ymax );

}                                        // Definition des Konstruktors


void Fenster::zeichneKoordinatensystem ()

{

   line( _xmin, 0, _xmax, 0 );

   line( 0, _ymin, 0, _ymax );
   for ( int x = ceil( _xmin ); x <= _xmax; x++ )
   {
      line( x, -0.05, x, 0.05 );
      text( x, -0.2 ) << x;
   }
   for ( int y = ceil( _ymin ); y <= _ymax; y++ )
   {
      line( -0.05, y, 0.05, y );
      if ( y != 0 )
         text( 0.05, y ) << y;
   }
}


void gmain ()
{
   double dx;

   Fenster sinus( "Sinusfunktion", XMIN, XMAX, YMIN, YMAX );
   Fenster cosinus( "Cosinusfunktion", XMIN, XMAX, YMIN, YMAX );
   dx = ( XMAX - XMIN ) / sinus.width();

   sinus.zeichneKoordinatensystem();
   cosinus.zeichneKoordinatensystem();

   sinus.pos( XMIN, sin( XMIN ) );
   cosinus.pos( XMIN, cos( XMIN ) );

   for ( double x = XMIN; x <= XMAX; x = x + dx )
   {
      sinus.draw( x, sin( x ) );
      cosinus.draw( x, cos( x ) );
   }

   sinus.activate();
   CP::msgBoxD();
   sinus.close();
   cosinus.activate();
   CP::msgBoxD();
}


