
// KLASSEN2.CPP
// Erzeugt wird eine Klasse Fenster, abgeleitet von der Klasse CPWindow.
// Die Klasse erhaelt einen eigenen Konstruktor.

#include <champ.h>
#include "klassen2.rh"


const double XMIN = -0.1;

const double XMAX = 6.5;
const double YMIN = -1.1;
const double YMAX = 1.1;


class Fenster : public CPWindow

{

   public :

      Fenster ( char titel[] );          // Deklaration des Konstruktors

      void zeichneKoordinatensystem ();

};


Fenster::Fenster ( char titel[] ) : CPWindow( titel )

{                                  // Definition des konstruktors, initialisiert

}                                  // wird der Konstruktor der Klasse CPWindow.


void Fenster::zeichneKoordinatensystem ()

{

   line( XMIN, 0, XMAX, 0 );

   line( 0, YMIN, 0, YMAX );
   for ( int x = ceil( XMIN ); x <= XMAX; x++ )
   {
      line( x, -0.05, x, 0.05 );
      text( x, -0.2 ) << x;
   }
   for ( int y = ceil( YMIN ); y <= YMAX; y++ )
   {
      line( -0.05, y, 0.05, y );
      if ( y != 0 )
         text( 0.05, y ) << y;
   }
}


void gmain ()
{
   double dx;

   Fenster sinus( "Sinusfunktion" );      // Instanziierung der Objekte, an den
   Fenster cosinus( "Cosinusfunktion" );  // Konstruktor wird ein String ueber-
   dx = ( XMAX - XMIN ) / sinus.width();  // geben.

   sinus.windowEven( XMIN, XMAX, YMIN, YMAX );
   cosinus.windowEven( XMIN, XMAX, YMIN, YMAX );

   sinus.zeichneKoordinatensystem();
   cosinus.zeichneKoordinatensystem();

   sinus.pos( XMIN, sin( XMIN ) );
   cosinus.pos( XMIN, cos( XMIN ) );

   for ( double x = XMIN; x <= XMAX; x = x + dx )
   {
      sinus.draw( x, sin( x ) );
      cosinus.draw( x, cos( x ) );
   }

   sinus.activate();
   CP::msgBox();
   sinus.close();
   cosinus.activate();
   CP::msgBox();
}


