
// KLASSEN1.CPP
// Erzeugt wird eine Klasse Fenster, abgeleitet von der Klasse CPWindow.

#include <champ.h>
#include "klassen1.rh"


const double XMIN = -0.1;

const double XMAX = 6.5;
const double YMIN = -1.1;
const double YMAX = 1.1;
                                        // Definition der Klasse Fenster, ein

class Fenster : public CPWindow         // Objekt dieser Klasse soll dieselben

{                                       // Eigenschaften haben wie ein Objekt der

   public :                             // Klasse CPWindow (Vererbung). Die

      void zeichneKoordinatensystem (); // Methode zeichneKoordinatensystem wird

};                                      // zusaetzlich definiert.

                                        // Semikolon nicht vergessen!!!


void Fenster::zeichneKoordinatensystem ()

{

   line( XMIN, 0, XMAX, 0 );            // Die Methode 'zeichneKoordinatensystem'

   line( 0, YMIN, 0, YMAX );            // wird definiert.
   for ( int x = ceil( XMIN ); x <= XMAX; x++ )
   {
      line( x, -0.05, x, 0.05 );
      text( x, -0.2 ) << x;
   }
   for ( int y = ceil( YMIN ); y <= YMAX; y++ )
   {
      line( -0.05, y, 0.05, y );
      if ( y != 0 )
         text( 0.05, y ) << y;
   }
}


void gmain ()
{
   double dx;

   Fenster sinus;                       // Instanziierung der Objekte sinus und
   Fenster cosinus;                     // cosinus der Klasse Fenster.
   dx = ( XMAX - XMIN ) / sinus.width();

   sinus.windowEven( XMIN, XMAX, YMIN, YMAX );
   cosinus.windowEven( XMIN, XMAX, YMIN, YMAX );

   sinus.zeichneKoordinatensystem();
   cosinus.zeichneKoordinatensystem();

   sinus.pos( XMIN, sin( XMIN ) );
   cosinus.pos( XMIN, cos( XMIN ) );

   for ( double x = XMIN; x <= XMAX; x = x + dx )
   {
      sinus.draw( x, sin( x ) );
      cosinus.draw( x, cos( x ) );
   }

   sinus.activate();
   CP::msgBoxD();
   sinus.close();
   cosinus.activate();
   CP::msgBoxD();
}


