
// SINCOSIN.CPP
// Zeichnet die Graphen der Sinus- und der Cosinusfunktion
// in zwei verschiedene Graphikfenster.

#include <champ.h>
#include "sincosin.rh"

const double XMIN = -0.1;
const double XMAX = 6.5;
const double YMIN = -1.1;
const double YMAX = 1.1;

void gmain ()
{
   double dx;                    // Schrittweite in for-Schleife

   CPWindow sinus( "Sinusfunktion", CP::WinBigSq );      // Instanziiert zwei
   CPWindow cosinus( "Cosinusfunktion", CP::WinBigSq );  // grosse Graphikfenster
   dx = ( XMAX - XMIN ) / sinus.width();

   sinus.windowEven( XMIN, XMAX, YMIN, YMAX );        // Setzt das Koordinatensy-
   cosinus.windowEven( XMIN, XMAX, YMIN, YMAX );      // stem in beiden Fenstern

   sinus.line( XMIN, 0, XMAX, 0 );                    // Koordinatensystem im
   sinus.line( 0, YMIN, 0, YMAX );                    // ersten Fenster
   cosinus.line( XMIN, 0, XMAX, 0 );                  // Koordinatensystem im
   cosinus.line( 0, YMIN, 0, YMAX );                  // zweiten Fenster
   for ( int ix = ceil( XMIN ); ix <= XMAX; ix++ )
   {
      sinus.line( ix, -0.05, ix, 0.05 );              // Beschriften der
      sinus.text( ix, -0.2 ) << ix;                   // x-Achsen
      cosinus.line( ix, -0.05, ix, 0.05 );
      cosinus.text( ix, -0.2 ) << ix;
   }
   
   for ( int iy = ceil( YMIN ); iy <= YMAX; iy++ )
   {
      sinus.line( -0.05, iy, 0.05, iy );              // Beschriften der
      cosinus.line( -0.05, iy, 0.05, iy );            // y-Achsen
      if ( iy != 0 )
      {
         sinus.text( 0.05, iy ) << iy;
         cosinus.text( 0.05, iy ) << iy;
      }
   }

   sinus.pos( XMIN, sin( XMIN ) );                    // Positioniert je einen
   cosinus.pos( XMIN, cos( XMIN ) );                  // Zeichenstift in beiden
                                                      // Fenstern.
   for ( double x = XMIN; x <= XMAX; x = x + dx )
   {
      sinus.draw( x, sin( x ) );
      cosinus.draw( x, cos( x ) );
   }

   sinus.activate();                                  // Aktiviert das Fenster
   CP::msgBoxD();                                     // 'sinus'
   sinus.close();                                     // Schliesst das Fenster
   cosinus.activate();                                // (Objekt) 'sinus'
   CP::msgBoxD();
}

