
// QUADRGL2.CPP
// Berechnet die Loesungen einer quadratischen Gleichung in der Grundmenge R.
// Beispiel fuer CP::msgBoxD

#include <conio.h>                         // Noetig fuer den Befehl clrscr();
#include <champ.h>
#include "quadrgl2.rh"

int berechneLoesungen ( double a, double b, double c, double & x1, double & x2 );

void gmain ()
{
   double a, b, c;                             // Koeffizienten
   double x1, x2;                              // Loesungen
   int i;                                      // vgl. Programm quadrgl1.cpp
   int antwort;                                // Variable, in der die Antwort
                                               // der Dialogbox gespeichert wird.
   char titel[] = "Quadratische Gleichungen";  // Titel der verschiedenen Fenster.

   cinit( titel );
   cout << "Dieses Programm loest die quadratische Gleichung ax^2 + bx + c = 0.";

   do
   {
      clrscr();           // Loescht den Inhalt des Konsolenfensters

      CPInputDouble( titel, "Koeffizient a:", a, 1 ).showModal();
      CPInputDouble( titel, "Koeffizient b:", b, 3 ).showModal();
      CPInputDouble( titel, "Koeffizient c:", c, 2 ).showModal();

      cout << "Sie haben die Gleichung " << a << "x^2 + " << b << "x + "
           << c << " = 0 eingegeben.\n\n";

      i = berechneLoesungen( a, b, c, x1, x2 );

      switch ( i )
      {
         case 0  :
            cout << "Diese Gleichung hat keine reellen Loesungen!";
            break;
         case 1  :
            cout << "Diese Gleichung hat die Loesung: x = " << x1;
            break;
         default :
            cout << "Diese Gleichung hat die Loesungen x1 = " << x1
                 << " und x2 = " << x2 << ".";
      }
      CP::msgBoxD( titel, MB_YESNO, antwort ) << "Wollen Sie noch eine weitere "
                                              << "Berechnung durchfuehren?";
   } while ( antwort == IDYES );
   CP::msgBoxD( titel ) << "Das Programm wird beendet!";
   cend();
}

int berechneLoesungen ( double a, double b, double c, double & x1, double & x2 )
{
   double diskr = b * b - 4 * a * c;    // Definition und Initialisierung
                                        // der Diskriminante
   if ( diskr < 0)
      return 0;                         // Die Gleichung hat keine Loesung,
                                        // also wird der Wert 0 zurueckgegeben.
   if ( diskr == 0 )
   {                                    // Die Gleichung hat eine Loesung, also
      x1 = ( -b ) / (2 * a);            // wird nur x1 berechnet. Zurueckgegeben
      return 1;                         // wird der Wert 1.
   }

   x1 = ( -b + sqrt( diskr ) ) / ( 2 * a );
   x2 = ( -b - sqrt( diskr ) ) / ( 2 * a );
   return 2;                            // Die Gleichung hat zwei Loesungen, also
}                                       // wird der Wert 2 zurueckgegeben.
