
// QUADRGL1.CPP
// Berechnet die Loesungen einer quadratischen Gleichung in der Grundmenge R.

#include <conio.h>              // Noetig fuer den Befehl clrscr();
#include <champ.h>
#include "quadrgl1.rh"

int berechneLoesungen ( double a, double b, double c, double & x1, double & x2 );

const char ESC = 27;            // ASCII-Code der ESC-Taste

void gmain ()
{
   double a, b, c;              // Koeffizienten
   double loesung1, loesung2;   // Loesungen
   int i;                       // Ist i = 2, dann hat die Gleichung 2 Loesungen
                                // Ist i = 1, dann hat die Gleichung 1 Loesung
                                // Ist i = 0, dann hat die Gleichung keine Loesung

   cinit( "Quadratische Gleichungen" );
   cout << "Dieses Programm loest die quadratische Gleichung ax^2 + bx + c = 0.";

   do
   {
      clrscr();                 // Loescht den Inhalt des Konsolenfensters

      CPInputDouble( "", "Geben Sie den Koeffizienten a ein", a, 1 ).showModal();
      CPInputDouble( "", "Geben Sie den Koeffizienten b ein", b, 3 ).showModal();
      CPInputDouble( "", "Geben Sie den Koeffizienten c ein", c, 2 ).showModal();

      cout << "Sie haben die Gleichung " << a << "x^2 + " << b << "x + "
           << c << " = 0 eingegeben.\n\n";

      i = berechneLoesungen( a, b, c, loesung1, loesung2 );

      switch ( i )
      {
         case 0  :
            cout << "Diese Gleichung hat keine reellen Loesungen!";
            break;
         case 1  :
            cout << "Diese Gleichung hat die Loesung: x = " << loesung1;
            break;
         default :
            cout << "Diese Gleichung hat die Loesungen x1 = " << loesung1
                 << " und x2 = " << loesung2 << ".";
      }

      cout << "\n\nESC-Taste: Programmabbruch";
      cout << "\nUebrige Tasten: Neue Berechnung";
   } while ( cgetch() != ESC );
   cend();
}

int berechneLoesungen ( double a, double b, double c, double & x1, double & x2 )
{
   double diskr = b * b - 4 * a * c;    // Definition und Initialisierung
                                        // der Diskriminante
   if ( diskr < 0)
      return 0;                         // Die Gleichung hat keine Loesung,
                                        // also wird der Wert 0 zurueckgegeben.
   if ( diskr == 0 )
   {                                    // Die Gleichung hat eine Loesung, also
      x1 = ( -b ) / (2 * a);            // wird nur x1 berechnet. Zurueckgegeben
      return 1;                         // wird der Wert 1.
   }

   x1 = ( -b + sqrt( diskr ) ) / ( 2 * a );
   x2 = ( -b - sqrt( diskr ) ) / ( 2 * a );
   return 2;                            // Die Gleichung hat zwei Loesungen, also
}                                       // wird der Wert 2 zurueckgegeben.
