
// FILE.CPP
// Ausgabe von Daten in einem File.

#include <champ.h>
#include <fstream.h>
#include "file.rh"

const double g = 9.807;                 // Fallbeschleunigung (Normwert)

void gmain ()
{
   ofstream ausgabe( "d:\\scratch\\schwurf.dat" );
   double v0;                        // Abwurfgeschwindigkeit
   double weite;

   cinit( "Schiefer Wurf" );
   cout << "Dieses Programm berechnet die Wurfweite in Abhaengigkeit des\n"
        << "Abwurfwinkels und der Anfangsgeschwindigkeit. Die Daten\n"
        << "werden in die Datei \'d:\\scratch\\schwurf.dat\' geschrieben.";
   cout << "\n\nGeben Sie die Anfangsgeschwindigkeit im m/s ein: ";
   cin >> v0;

   ausgabe << "Wurfweiten bei einer Anfangsgeschwindigkeit von " << v0 << " m/s."
           << "\n\nAbwurfwinkel\tWeite: \n\n";

   ausgabe << setprecision( 3 );    // Angabe auf drei wesentliche Stellen genau.
   for ( int winkel = 0; winkel <= 90; winkel++ )
   {
      weite = pow ( v0, 2 ) * sin ( 2 * M_PI * winkel / 180.0 ) / g;
      ausgabe << winkel << "\t" << weite << " m \n";
   }

   CP::msgBoxD() << "Die Berechnung ist erfolgreich abgeschlossen worden.";
   cend();
}
