// STATICEX3.CPP

#define OBJECT_TURTLE
#include <champ.h>


// =================== Class TurtleFamily interface =================
class TurtleFamily
{
public:
   TurtleFamily ();
   int howMany ();
   void addChild ();
   bool removeChild ( int nb );
   void cleanup ();


private:
   CPList<Turtle*> children;
   int nbChildren;
};

// =================== Class TurtleFamily implementaion =============
TurtleFamily::TurtleFamily ()
{
   nbChildren = 0;
}

int TurtleFamily::howMany ()
{
   return nbChildren;
}

void TurtleFamily::addChild ()
{
   Turtle * pChild = new Turtle;
   pChild->setPos( 30*nbChildren, 0 );
   children.insertTail( pChild );
   nbChildren++;
}

bool TurtleFamily::removeChild ( int nb )
{
   if ( nb < 0 || nb > nbChildren-1 )
   {
      CP::msgBox( "Error in removeChild" ) << "Child's index not valuable";
      return false;
   }

   children.restartAtHead();
   for ( int i = 0; i < nb; i++ )
      children.next();
   delete children.current();   // Delete object
   children.removeCurrent();    // Remove it from list
   nbChildren--;
   return true;
}

void TurtleFamily::cleanup ()
{
    for ( children.restartAtHead(); children; children.next() )
      delete children.current();
}

// =================== Main ========================================
void gmain ()
{
   ginit( "StaticEx3" );

   TurtleFamily meyer;
   for ( int i = 0; i < 4; i++ )
      meyer.addChild();

   CP::msgBox() << "Number of children: " << meyer.howMany() << endl
                << "Press OK to let child # 1 child vanish.";

   meyer.removeChild( 1 );

   CP::msgBox() << "Number of children now: " << meyer.howMany() << endl
                << "Press OK to terminate.";

   meyer.cleanup();
   gend();
}
