// STATICEX2.CPP

#define OBJECT_TURTLE
#include <champ.h>

// const int maxIndex = 3;   // Global class constant (ugly)

// =================== Class TurtleFamily interface =================
class TurtleFamily
{
public:
   TurtleFamily ();
   int howMany ();
   bool addChild ();
   bool removeLastChild ();

private:
   // Maximum number of children: maxIndex + 1
   enum { maxIndex = 3 };    // Enum hack for integer class constants
   int index;
   Turtle * pChildren[maxIndex+1];
};

// =================== Class TurtleFamily implementaion =============
TurtleFamily::TurtleFamily ()
{
   index = 0;
}

int TurtleFamily::howMany ()
{
   return index;
}

bool TurtleFamily::addChild ()
{
   if ( index > maxIndex )
   {
      CP::msgBox( "Error in addChild" ) << "No place for more children";
      return false;
   }

   pChildren[index] = new Turtle;
   pChildren[index]->setPos( 30*index, 0 );
   index++;
   return true;
}

bool TurtleFamily::removeLastChild ()
{
   if ( index == 0 )
   {
      CP::msgBox( "Error in removeLastChild" ) << "No children left";
      return false;
   }

   index--;
   delete pChildren[index];
   return true;
}


// =================== Main ========================================
void gmain ()
{
   ginit( "StaticEx2" );

   TurtleFamily meyer;
   meyer.addChild();
   meyer.addChild();
   meyer.addChild();
   CP::msgBox() << "Number of children: " << meyer.howMany() << endl
                << "Press OK to let last child vanish.";

   meyer.removeLastChild();

   CP::msgBox() << "Number of children now: " << meyer.howMany() << endl
                << "Press OK to terminate.";

   // Cleanup
   for ( int i = 0; i < meyer.howMany(); i++ )
      meyer.removeLastChild();

   gend();
}
