// FLOATIN.CPP
// Validate floating point number in edit field

#include <champ.h>
#include "floatin.rh"

void doOk ( CPDialog & dlg );
bool validate ( char * valueStr, double & value );

void gmain ()
{
   CPModelessDialog dlg( "UserDialog" );
   dlg.showModeless();
   CPPushButton okButton( dlg, IDOK, doOk );

   while ( !dlg.isClosed() )
      CP::yield();
}

void doOk ( CPDialog & dlg )
{
   char valueStr[20];
   double value;

   CPEdit input( dlg, IDC_INPUT );
   CPEdit output( dlg, IDC_OUTPUT );
   input.text().getline( valueStr, sizeof( valueStr ), '\n' );
   if ( validate( valueStr, value ) )
   {
      output.text() << value << ends;
   }
   else
   {
      CP::msgBox( "Error" ) << "Illegal entry";
   }
}

bool validate( char * valueStr, double & value )
{
   istrstream is( valueStr );
   if ( is.eof() )
       return false; // Empty entry
   else
   {
      is >> value;    // Try to convert
      if ( is.fail() )         // Can't convert
         return false;
      else
      {
         is >> ws;  // Throw away whitespaces
         // We test if there is an illegal trailing part
         ostrstream os;
         os << is.rdbuf() << ends;  // Get the trailing part
         int len = strlen( os.str() );
         delete os.str();
         if ( len > 0 )
            return false;
         return true;
      }
   }
}


