// DLGIMG2.CPP

#include <champ.h>
#include "dlgimg2.rh"

void doQuit ();
void doToggle ();
void setRed ();
void setGreen ();
enum { on, off } state = off;

bool quitting = false;
HWND hwndDlg;

void gmain ()
{
   CPModelessDialog dlg( "DLGIMG" );
   dlg.showModeless();
   hwndDlg = dlg.hwnd(); // Get handle after dialog is shown!
   CPPushButton quitBtn( dlg, ID_QUIT, doQuit );
   CPPushButton toggleBtn( dlg, ID_TOGGLE, doToggle );
   setRed();

   while ( !quitting )
      CP::yield();

}

void doQuit ()
{
   quitting = true;
}

void doToggle ()
{
   if ( state == off )
   {
      setGreen();
      state = on;
   }
   else
   {
      setRed();
      state = off;
   }
}

void setGreen ()
{
   ShowWindow( GetDlgItem( hwndDlg, ID_GREENLED ), SW_SHOW );
   ShowWindow( GetDlgItem( hwndDlg, ID_REDLED ), SW_HIDE );
}

void setRed ()
{
   ShowWindow( GetDlgItem( hwndDlg, ID_REDLED ), SW_SHOW );
   ShowWindow( GetDlgItem( hwndDlg, ID_GREENLED ), SW_HIDE );
}


