// PANEL.CPP

#include <champ.h>
#include "panel.h"
#include "dlgapp.rh"

extern enum State { idle, stopped, running, quitting } state;


// -------------- class FrameWindow ---------------------------
Panel::FrameWindow::FrameWindow ( const char * title, Panel & dlg )
   : CPWindow( title, CPSize( dlg.frameWidth(), dlg.frameHeight() ),
                CPPosition( 20, 20 ) ),
      _dlg( dlg ),
      _menu( "MENU1" )
{
   dlg.showModeless( *this, CP::upperLeft );
   setFocusChildDialog( _dlg );
   setMenu( _menu );
}

void Panel::FrameWindow::evWindowClose ()
{
   int userResponse;
   CP::msgBox( "Warning", MB_YESNO, userResponse ) << "Are you sure to quit?";
   if ( userResponse == IDYES )
     state = quitting;
}

bool Panel::FrameWindow::evMenuSelect ( unsigned int id )
{
   switch ( id )
   {
      case IDM_INFO:
         CP::msgBox( "Info" ) << "Thanks for trying to get some info";
         break;

      case IDM_EXIT:
         evWindowClose();
         break;

       default:
          return FALSE;
   }
   return TRUE;
}


// -------------- class Panel ---------------------------
Panel::Panel ( const char * title, int & x )
   : CPModelessDialog( "DIALOG1" ),
     _pFrame( 0 ),
     _x( x ),
     _resultEdit( *this, IDE_RESULT ),
     _startBtn( *this, IDB_START ),
     _stopBtn( *this, IDB_STOP ),
     _resumeBtn( *this, IDB_RESUME )
{
   _pFrame = new FrameWindow( title, *this );
   _resultEdit.setAutoScroll( true );
   enableStart();
}

Panel::~Panel ()
{
   delete _pFrame;
}

void Panel::evPushButtonClick( CPPushButton & btn )
{
   switch ( btn.id() )
   {
      case IDB_START:
         _resultEdit.clear();
         _x = 0;
         state = running;
         enableStop();
         break;

      case IDB_STOP:
         state = stopped;
         enableResume();
         break;

      case IDB_RESUME:
         state = running;
         enableStop();
         break;

   }
}

void Panel::showResult ( double x, double y )
{
   _resultEdit.text() << setiosflags( ios::fixed );
   _resultEdit.text() << setprecision( 0 );
   _resultEdit.text() << "x = " << setw( 6 ) << x;
   _resultEdit.text() << setprecision( 3 );
   _resultEdit.text() <<  setw( 7 ) << "y = " << y << endl;
}

void Panel::enableStart ()
{
   _startBtn.setEnabled();
   _startBtn.setFocus();
   _stopBtn.setGrayed();
   _resumeBtn.setGrayed();
}

void Panel::enableStop ()
{
   _startBtn.setGrayed();
   _stopBtn.setEnabled();
   _stopBtn.setFocus();
   _resumeBtn.setGrayed();
}

void Panel::enableResume ()
{
   _startBtn.setEnabled();
   _stopBtn.setGrayed();
   _resumeBtn.setEnabled();
   _resumeBtn.setFocus();
}

