// DLGAPP.CPP

#include <champ.h>
#include "panel.h"

enum State { idle, stopped, running, quitting } state = idle;

void gmain ()
{
   const int maxX = 100;
   int x = 0;
   int y;
   Panel pan( "Dialog Application", x );
   state = idle;


   // State event loop
   while ( state != quitting )
   {
      switch ( state )
      {
         case idle:
         case stopped:
            CP::yield();
            break;

         case running:
            CP::yield();
            y = sqrt( x );
            pan.showResult( x, y );
            if ( x == maxX )
            {
               x = 0;
               state = idle;
               pan.enableStart();
            }
            else
               x++;
            break;
      }
   }
   CP::msgBox() << "Garbage collection (if needed) here. Will execute in any case";
}
