// FUNC5.CPP
// Spezialfaelle von Funktionen als abgeleitete Funktionsobjekte

#include <champ.h>

template<class T> void showFunc( T & pF, double xmin, double xmax, double step )
{
   double ymax = pF( xmin );
   double ymin = ymax;
   double x;

   // Einpassen der Fensterkoordinaten
   for ( x = xmin; x <= xmax; x += step )
   {
     if ( ymin > pF( x ) )
        ymin = pF( x );
     if ( ymax < pF( x ) )
        ymax = pF( x );
   }
   gwindow( xmin, xmax, ymin, ymax );

   gpos( xmin, pF( xmin ) );
   for ( x = xmin; x <= xmax; x += step )
      gdraw( x, pF( x ) );
}

class Normalverteilung
{
public:
   Normalverteilung ( double s, double u )
      : _s( s ), _u( u )
   {}

   double operator () ( double x )
   {
      return 1 / ( sqrt( 2*M_PI )*_s ) * exp( - (x - _u)*(x - _u) / ( 2*_s*_s ) ) ;
   }

   void show ( double xmin, double xmax )
   {
      showFunc( *this, xmin, xmax, 0.01 );
   }

private:
   double _s;
   double _u;
};

class Schwingung
{
public:
   Schwingung ( double a, double b, double w )
      : _a( a ), _b( b ), _w( w )
   {}

   double operator () ( double x )
   {
      return _a * exp( -_b*x ) * sin( _w* x );
   }

   void show ( double xmin, double xmax )
   {
      showFunc( *this, xmin, xmax, 0.01 );
   }

private:
   double _a;
   double _b;
   double _w;
};

class SinusSchwingung : public Schwingung
{
public:
   SinusSchwingung ( double a, double w )
      : Schwingung( a, 0, w )
   {}
};

void gmain ()
{
   ginit( "FUNC5" );

   Normalverteilung f( 1, 2 );
   f.show( -10, 10 );

   SinusSchwingung g( 2, 4 );
   g.show( -10, 10 );
}


