// FUNC3.CPP
// Generisches Programmieren: showFunc bleibt fr Funktionen mit
// unterschiedlicher Zahl und Typ der Parameter gleich

#include <champ.h>

template<class T> void showFunc( T & pF, double xmin, double xmax, double step )
{
   double ymax = pF( xmin );
   double ymin = ymax;
   double x;

   // Anpassen der Fensterkoordinaten
   for ( x = xmin; x <= xmax; x += step )
   {
     if ( ymin > pF( x ) )
        ymin = pF( x );
     if ( ymax < pF( x ) )
        ymax = pF( x );
   }
   gwindow( xmin, xmax, ymin, ymax );

   gpos( xmin, pF( xmin ) );
   for ( x = xmin; x <= xmax; x += step )
      gdraw( x, pF( x ) );
}

class Normalverteilung
{
public:
   Normalverteilung ( double s, double u )
      : _s( s ), _u( u )
   {}

   double operator () ( double x )
   {
      return 1 / ( sqrt( 2*M_PI )*_s ) * exp( - (x - _u)*(x - _u) / ( 2*_s*_s ) ) ;
   }

   void show ( double xmin, double xmax )
   {
      showFunc( *this, xmin, xmax, 0.01 );
   }

private:
   double _s;
   double _u;
};

void gmain ()
{
   ginit( "FUNC3" );

   double s = 1;
   double u = 2;
   Normalverteilung f( s, u );

   double xmin = -10;
   double xmax = 10;
   f.show( xmin, xmax );
}


