// FUNC2.CPP
// Objektorientierter Ansatz: Funktionsobjekte (Parameter sind Attribute)

#include <champ.h>

class Normalverteilung
{
public:
   Normalverteilung ( double s, double u )
      : _s( s ), _u( u )
   {}

   double operator () ( double x )
   {
      return 1 / ( sqrt( 2*M_PI )*_s ) * exp( - (x - _u)*(x - _u) / ( 2*_s*_s ) ) ;
   }

private:
   double _s;
   double _u;
};

void gmain ()
{
   ginit( "FUNC2" );

   double s = 1;
   double u = 2;
   Normalverteilung f( s, u );

   double step = 0.01;
   double xmin = -10;
   double xmax = 10;
   double x;
   double ymin = f( xmin );
   double ymax = ymin;

   // Anpassen der Fensterkoordinaten
   for ( x = xmin; x <= xmax; x += step )
   {
     if ( ymin > f( x ) )
        ymin = f( x );
     if ( ymax < f( x ) )
        ymax = f( x );
   }
   gwindow( xmin, xmax, ymin, ymax );

   gpos( xmin, f( xmin ) );
   for ( x = xmin; x <= xmax; x += step )
      gdraw( x, f( x ) );
}
