// POP4.CPP
// Private copy ctor and assignment op will inhibit dangerous operations

#include <champ.h>
#include <stdlib.h>

#define dead false
#define alive true


class Population
{
public:
   Population ( int size );
   ~Population () { delete [] _pPop; }
   void fillDead ();
   void fillAlive ();
   void fillRandom ();
   void show ();

private:
   Population ( const Population & p );
   Population & operator= ( const Population & p );
   int _size;
   bool * _pPop;
};

Population::Population ( int size )
   : _size( size )
{
   _pPop = new bool[_size];
   fillAlive();
}

void Population::fillRandom ()
{
   randomize();
   for ( int i = 0; i < _size; i++ )
      _pPop[i] = (bool)random( 2 );
}

void Population::fillDead ()
{
   for ( int i = 0; i < _size; i++ )
      _pPop[i] = dead;
}

void Population::fillAlive ()
{
   for ( int i = 0; i < _size; i++ )
      _pPop[i] = alive;
}


void Population::show ()
{
   for ( int i = 0; i < _size; i++ )
      cout << i << " : " << ( _pPop[i] == alive ? "alive" : "dead" ) << endl;
   cout << endl;
}


void gmain ()
{
   cinit( "POP4" );
   Population p1( 10 );
   p1.fillRandom();
   p1.show();

   Population p2 = p1;        // Generates compilation error
   p2.show();

   p2.fillDead();
   p1.show();

   Population p3( 10 );
   p3 = p1;                  // Generates compilation error

   p3.fillAlive();
   p1.show();
}
