// POP3.CPP
// Copy constructor and assignment operator defined
//

#include <champ.h>
#include <stdlib.h>

#define dead false
#define alive true


class Population
{
public:
   Population ( int size );         // Ctor
   Population ( const Population & p );   // Copy ctor
   Population & operator= ( const Population & p );    // Assignment op
   void fillDead ();
   void fillAlive ();
   void fillRandom ();
   void show ();

private:
   int _size;
   bool * _pPop;
};

Population::Population ( int size )
   : _size( size )
{
   if ( size < 1 )
   {
      CP::msgBox( "Fatal Error" ) << "Illegal parameter in constructor of class Population";
      exit( 1 );
   }
   _pPop = new bool[_size];
   fillAlive();
}

Population::Population ( const Population & p )
{
   cout << "Copy constructor executing..." << endl;
   _size = p._size;
   _pPop = new bool[_size];
   for ( int i = 0; i < _size; i++ )
      _pPop[i] = p._pPop[i];
}

Population & Population::operator= ( const Population & p )
{
   cout << "Assignment operator executing..." << endl;
   _size = p._size;
   delete [] _pPop;
   _pPop = new bool[_size];
   for ( int i = 0; i < _size; i++ )
      _pPop[i] = p._pPop[i];
   return *this;
}

void Population::fillRandom ()
{
   randomize();
   for ( int i = 0; i < _size; i++ )
      _pPop[i] = (bool)random( 2 );
}

void Population::fillDead ()
{
   for ( int i = 0; i < _size; i++ )
      _pPop[i] = dead;
}

void Population::fillAlive ()
{
   for ( int i = 0; i < _size; i++ )
      _pPop[i] = alive;
}


void Population::show ()
{
   for ( int i = 0; i < _size; i++ )
      cout << i << " : " << ( _pPop[i] == alive ? "alive" : "dead" ) << endl;
   cout << endl;
}


void gmain ()
{
   cinit( "POP3" );
   Population p1( 10 );
   p1.fillRandom();
   p1.show();

   Population p2 = p1;                // Copy constructor used
   p2.show();

   p2.fillDead();
   p1.show();

   Population p3( 2 );
   // Size not important because space will be released by following =
   p3 = p1;                          // Assignment operator used
   // Same as p3.operator=( p1 );

   p3.fillAlive();
   p1.show();
}
