// POP2.CPP
// Copy object will not copy dynamic array

#include <champ.h>
#include <stdlib.h>

#define dead false
#define alive true


class Population
{
public:
   Population ( int size );
   ~Population () { delete [] _pPop; }
   void fillDead ();
   void fillAlive ();
   void fillRandom ();
   void show ();

private:
   int _size;
   bool * _pPop;
};

Population::Population ( int size )
   : _size( size )
{
   _pPop = new bool[_size];
   fillAlive();
}

void Population::fillRandom ()
{
   randomize();
   for ( int i = 0; i < _size; i++ )
      _pPop[i] = (bool)random( 2 );
}

void Population::fillDead ()
{
   for ( int i = 0; i < _size; i++ )
      _pPop[i] = dead;
}

void Population::fillAlive ()
{
   for ( int i = 0; i < _size; i++ )
      _pPop[i] = alive;
}


void Population::show ()
{
   for ( int i = 0; i < _size; i++ )
      cout << i << " : " << ( _pPop[i] == alive ? "alive" : "dead" ) << endl;
   cout << endl;
}


void gmain ()
{
   cinit( "POP2" );
   Population p1( 10 );
   p1.fillRandom();
   p1.show();

   Population p2 = p1;        // Default copy constructor used
   p2.show();

   p2.fillDead();             // Will also set p1 dead
   p1.show();                 // Here you see it

   Population p3( 10 );
   p3 = p1;                  // Default assignment operator used

   p3.fillAlive();           // Will also set p1 alive
   p1.show();                // Here you see it
}
