// POP1A.CPP
// If an object A has a data member B, which is an object,
// B must be initialized by the constructor of A

// Whenever the copy constructor or assignment operator of A is
// called, the same happens to B.
// Therefore whenever A is copied, we get a perfect clone,
// e.g.  C++ performs a "deep copy"

#include <champ.h>
#include <stdlib.h>

#define POPSIZE 10
#define dead false
#define alive true

class Point
{
public:
   // Constructor
   Point ( double x, double y );
   // Accessors
   double getX () { return _x; }
   double getY () { return _y; }
   void setX ( double x ) { _x = x; }
   void setY ( double y ) { _y = y; }

private:
   double _x;
   double _y;

};

Point::Point ( double x, double y )
{
   cout << "Constructor of Point executing..." <<  endl;
   _x = x;
   _y = y;
}


class Population
{
public:
   Population ();
   void fillDead ();
   void fillAlive ();
   void fillRandom ();
   void show ();

   Point _point;          // Object data member

private:
   bool _pop[POPSIZE];
};

Population::Population ()
   : _point( 0, 0 )       // All object data members must be initialized or
{                         // compile time error results
   fillAlive();
}

void Population::fillRandom ()
{
   randomize();
   for ( int i = 0; i < POPSIZE; i++ )
      _pop[i] = (bool)random( 2 );
}

void Population::fillDead ()
{
   for ( int i = 0; i < POPSIZE; i++ )
      _pop[i] = dead;
}

void Population::fillAlive ()
{
   for ( int i = 0; i < POPSIZE; i++ )
      _pop[i] = alive;
}

void Population::show ()
{
   for ( int i = 0; i < POPSIZE; i++ )
      cout << i << " : " << ( _pop[i] == alive ? "alive" : "dead" ) << endl;
   cout << "Point( " << _point.getX() << "," << _point.getY() << " )" << endl << endl;
}

void gmain ()
{
   cinit( "POP1A" );
   Population p1;
   p1.fillRandom();
   p1.show();

   p1._point.setX( 1 );
   Population p2 = p1;   // Default copy constructor of Population AND Point called
   p2.show();            // Values of all data members copied form p1 to p2

   Population p3;
   p3 = p1;              // Default operator= of Population AND Point called
   p3.show();            // Values of all data members copied form p1 to p3

}
