// POP1.CPP
// Use of OOP will pack all attributes and methods of a population together

#include <champ.h>
#include <stdlib.h>

#define POPSIZE 10
#define dead false
#define alive true

// --- Class Population : Interface ---
class Population
{
public:
   Population ();
   void fillDead ();
   void fillAlive ();
   void fillRandom ();
   void show ();

private:
   bool _pop[POPSIZE];
};

// --- Class Population : Implementation ---
Population::Population ()
{
   fillAlive();
}

void Population::fillRandom ()
{
   randomize();
   for ( int i = 0; i < POPSIZE; i++ )
      _pop[i] = (bool)random( 2 );
}

void Population::fillDead ()
{
   for ( int i = 0; i < POPSIZE; i++ )
      _pop[i] = dead;
}

void Population::fillAlive ()
{
   for ( int i = 0; i < POPSIZE; i++ )
      _pop[i] = alive;
}

void Population::show ()
{
   for ( int i = 0; i < POPSIZE; i++ )
      cout << i << " : " << ( _pop[i] == alive ? "alive" : "dead" ) << endl;
   cout << endl;
}

// --- Main ---
void gmain ()
{
   cinit( "POP1" );
   Population p1;
   p1.fillRandom();
   p1.show();

   Population p2 = p1;       // Default (build-in) copy constructor used
   p2.show();

   p2.fillDead();            // Set only p2 dead
   p1.show();                // p1 remains the same

   Population p3;
   p3 = p1;                  // Default (build-in) assignment operator used
   p3.fillAlive();           // Set p3 alive
   p1.show();                // p1 remains the same
}
