// SETSPEED.CPP

#define OBJECT_TURTLE
#include <string.h>
#include <champ.h>
#include <cpvbx.h>

#include "setspeed.rh"

void knobEvent ( CPVbxControl & knob , VBXEVENT & event );

// Globals
Turtle john( RED );
CPModelessDialog reglerDialog( "ReglerDialog" );
CPVbxControl knob( "knob1.vbx", reglerDialog, IDC_KNOB1 );
CPVbxControl indicator( "vindic1.vbx", reglerDialog, IDC_HINDICATOR1 );
bool stopped = false;

void gmain ()
{
   CPWindow wnd( "SetSpeed" );
   wnd.clear( LIGHTGREEN );
   knob.registerEvent( knobEvent );

   reglerDialog.showModeless( wnd, CP::lowerLeft );

   long val = 125;
   long maxval = 250;
   knob.setPropByName( "Min", 0 );
   knob.setPropByName( "Max", maxval );
   knob.setPropByName( "Value", val );
   indicator.setPropByName( "Min", 0 );
   indicator.setPropByName( "Max", maxval );
   indicator.setPropByName( "Value", val );

   john.setPos( wnd, 0, 0 );
   john.speed( (int)val );

   while ( true )
   {
      if ( stopped )
         CP::yield();
      else
      {
         john.forward( 10 );
         john.left( 10 );
      }
   }
}


void knobEvent ( CPVbxControl & knob , VBXEVENT & event )
{
   long val;
   if ( !strcmpi( event.EventName, "Scroll" ) )
   {
      knob.getPropByName( "Value", &val );
      indicator.setPropByName( "Value", val );
      if ( int(val) == 0 )
         stopped = true;
      else
      {
         stopped = false;
         john.speed( (int)val );
      }
   }
}

