// FUNCPARS.CPP
// Using UCALC library (www.ucalc.com)

#include <champ.h>
#include "ucalc.cpp"

void gmain()
{
   ginit( "Function parser" );
   gwindow( -10, 10, -100, 100 );
   gline( -10, 0, 10, 0 );
   gline( 0, -100, 0, 100 );

   long double x, y;
   char expression[80];
   long pExpression, pVariable;  // Called "pointer" in ucalc library

   pVariable = ucDefineVariable( "x" );

   CPInputString input( "Function", "Enter an expression:",
                        expression, 80, "100*exp(-0.1*x^2)" );

   while ( input.showModal( CPPosition( 500, 30 ) ) == IDOK )
   {
      pExpression = ucParse( expression );

      for ( x = -10; x <= 10; x += 0.1 )
      {
         ucSetVariableValue( pVariable, x );
         y = ucEvaluate( pExpression );
         if ( x == -10 )
            gpos( x, y );
         else
            gdraw( x, y );
      }
   }
   ucReleaseExpr();
//   gend();
}
