// BIRDS.CPP

#include <champ.h>

// -------------  Interface normally in BIRDS.H
class Bird
{
public:
   Bird ();
   virtual void whistle ();   // Must be virtual
};

class Handler
{
public:
   static void go ();
   static CPList<Bird *> list;
};

// ------------- End of interface

CPList<Bird *> Handler::list;

void Handler::go ()
{

  for ( list.restartAtHead();  // Start with the first element
        list;                  // Loop while list is ok
        list.next() )          // Advance to next element
   {
      list.current()->whistle();
   }

}

Bird::Bird ()
{
   Handler::list.insert( this );
}

void Bird::whistle ()
{
   cout << "sheweeee......";
}

//  Sparrow may or may not override method whistle (outcommented here)
class Sparrow : public Bird
{
   virtual void whistle();
};


void Sparrow::whistle ()
{
   cout << "zwaawaa.......";
}



void gmain ()
{
   cinit();
   Handler handler;
   Sparrow sparrow;

   handler.go();
}





