// WHEAT.CPP

#include <champ.h>
#include "wheat.rh"
#include "cpbitmap.h"
#include "matrix.h"

typedef matrix<double> Matrix;

#define WINWIDTH 700
#define WINHEIGHT 600
#define XOFFSET 10
#define YOFFSET 20

double R1;
double R2 = 20; // Ohm
double R3 = 30;
double R4 = 40;
double R5 = 50;

double U0 = 10;  // Volt


void doOk ( CPDialog & dlg );
bool validate ( char * valueStr, double & value );
double calculate( double R1 );

CPWindow wnd( "Wheatstonesche Brcke", CPSize( WINWIDTH, WINHEIGHT ) );

void gmain ()
{
   CPBitmap m;
   m.loadBitmap( "Wheat" );
   m._put( wnd, XOFFSET, YOFFSET );

   CPModelessDialog dlg( "UserDialog" );
   dlg.showModeless( wnd, CP::upperRight );
   wnd._textFont( "Times New Roman", -20 );
   CPPushButton okButton( dlg, IDOK, doOk );

   while ( true )
      CP::yield();
}

void doOk ( CPDialog & dlg )
{
   int xR1 = 95;
   int yR1 = 60;
   char valueStr[20];
   double value;

   CPEdit input( dlg, IDC_INPUT );
   CPEdit output( dlg, IDC_OUTPUT );
   input.text() >> valueStr;
   if ( validate( valueStr, value ) )
   {
      wnd._text( xR1 + XOFFSET, yR1 + YOFFSET ) << value;
      output.text() << calculate( value ) << ends;
   }
   else
   {
      CP::msgBox( "Error" ) << "Illegal entry";
   }
}


bool validate( char * valueStr, double & value )
{
   istrstream is( valueStr );
   if ( is.eof() )
       return false; // Empty entry
   else
   {
      is >> value;    // Try to convert
      if ( is.fail() )         // Can't convert
         return false;
      else
      {
         // The following line will delete everything after the first space
         // It is unnecessary because is will be destroyed anywhy
//         is.clear();
         return true;
      }
   }
}

double calculate ( double R1 )
{
   Matrix A( 6, 6 );
   Matrix xRow( 6, 1 );
   Matrix bRow( 6, 1 );

   A( 0, 0 ) =  0; A( 0, 1 ) = -1; A( 0, 2 ) =  0;
   A( 0, 3 ) =  1; A( 0, 4 ) =  0; A( 0, 5 ) = -1;

   A( 1, 0 ) = -1; A( 1, 1 ) =  1; A( 1, 2 ) =  1;
   A( 1, 3 ) =  0; A( 1, 4 ) =  0; A( 1, 5 ) =  0;

   A( 2, 0 ) =  1; A( 2, 1 ) =  0; A( 2, 2 ) =  0;
   A( 2, 3 ) = -1; A( 2, 4 ) = -1; A( 2, 5 ) =  0;

   A( 3, 0 ) =  0; A( 3, 1 ) =-R1; A( 3, 2 ) = R2;
   A( 3, 3 ) =  0; A( 3, 4 ) =  0; A( 3, 5 ) = R5;

   A( 4, 0 ) =  0; A( 4, 1 ) =  0; A( 4, 2 ) =  0;
   A( 4, 3 ) = R3; A( 4, 4 ) =-R4; A( 4, 5 ) = R5;

   A( 5, 0 ) =  0; A( 5, 1 ) =-R1; A( 5, 2 ) =  0;
   A( 5, 3 ) =-R3; A( 5, 4 ) =  0; A( 5, 5 ) =  0;

   bRow( 0, 0 ) = 0; bRow( 1, 0 ) = 0; bRow( 2, 0 ) =   0;
   bRow( 3, 0 ) = 0; bRow( 4, 0 ) = 0; bRow( 5, 0 ) = -U0;

   xRow = !A * bRow;
   return R5 * xRow( 5, 0 );
}


