// CPFFT.H

#if !defined(__CPFFT_H)      // Include only if not yet included
#define __CPFFT_H

class CPFft
{
public:
   CPFft( float *  fftAry, int fftOrder, float samplingFreq, int filterType,
          bool logScale = false );
   ~CPFft ();
   void transform ();

private:
   long fdiv ( double a, double b );
   void realft ( float data[], int n, int isign );
   void four1 ( float data[], int nn, int isign );

   float * _fftAry;
   float * _normAry;
   int _fftOrder;
   float _samplingFreq;
   int _filterType;
   bool _logScale;
};

#endif  // __CPFFT

