// CPCROPIX.H

#include <champ.h>

class CroPix : public CPWindow
{
public:
   static enum TraceType { lines, sticks };

   CroPix (
      const char * title,               // Window title
      int ulx, int uly,                 // Window upper left coordinates
      int width,                        // Window width
      int height,                       // Window height
      const char * xunit,               // Unit x-axis
      const char * yunit,               // Unit y-Achse
      int xlines,                       // Number of x gridline sections
      int ylines,                       // Number of y gridline sections
      int xticks,                       // Number of x tick sections
      int yticks,                       // Number of y tick sections
      CPColor windowColor = LIGHTCYAN,  // Window color
      CPColor gridColor = CYAN,         // Grid color
      CPColor traceColor = BLACK,       // Window color
      TraceType traceType = lines );

   void drawGrid ();
   void drawTicks ();
   void showTrace ( unsigned char dataAry[], unsigned nbSamples );
   void showTraceFloat ( float * dataAry, unsigned nbSamples );

private:
   void leftArrow ( CPWindow & w, int x, int y, CPColor color );
   void rightArrow ( CPWindow & w, int x, int y, CPColor color );
   void upArrow ( CPWindow & w, int x, int y, CPColor color );
   void downArrow ( CPWindow & w, int x, int y, CPColor color );
   void drawLabel ();
   int _xmax, _ymax;
   char _xunit[20];
   char _yunit[20];
   int _xlines;
   int _ylines;
   int _xticks;
   int _yticks;
   CPColor _windowColor;
   CPColor _gridColor;
   CPColor _traceColor;
   TraceType _traceType;
};

