// CPCROPIX.CPP

#include "cpcropix.h"
#include <string.h>
unsigned char oldAry[2000];
float oldFloatAry[2049];


const int w = 10;

CroPix::CroPix (
      const char * title,        // Window title
      int ulx, int uly,          // Window upper left coordinates
      int xmax,                  // x-axis 0..xmax ( in pixels)
      int ymax,                  // y-axis 0..ymax ( in pixels )
      const char * xunit,        // Unit x-axis
      const char * yunit,        // Unit y-Achse
      int xlines,                // Number of x gridline sections
      int ylines,                // Number of y gridline sections
      int xticks,                // Number of x tick sections
      int yticks,                // Number of y tick sections
      CPColor windowColor,       // Window color
      CPColor gridColor,         // Grid color
      CPColor traceColor,        // Trace color
      TraceType traceType )      // Trace type
          : CPWindow( title, CPSize( xmax+3*w, ymax+3*w ),
                      CPPosition( ulx, uly ) )
{
   _xmax = xmax;
   _ymax = ymax;
   strcpy( _xunit, xunit );
   strcpy( _yunit, yunit );
   _xlines = xlines;
   _ylines = ylines;
   _xticks = xticks;
   _yticks = yticks;
   _windowColor = windowColor;
   _gridColor = gridColor;
   _traceColor = traceColor;
   _traceType = traceType;

   int n;
   for ( n = 0; n < 2000; n++ )
      oldAry[n] = 0;
   for ( n = 0; n < 2049; n++ )
      oldFloatAry[n] = 0;

   clear( windowColor  );
   fillColor( windowColor );
   penColor( gridColor );
   penColor( traceColor );

   drawTicks();
   drawGrid();
};

void CroPix::drawGrid ()
{
   int i;
   penColor( _gridColor );

   float xstep = float(_xmax) / _xlines;
   float ystep = float(_ymax) / _ylines;

   // Vertical lines
   for ( i = 0; i <= _xlines; i++ )
   {
      _move( i * xstep + 2*w, w );
      _draw( i * xstep + 2*w, _ymax + w );
   }

   // Horizontal lines
   for ( i = 0; i <= _ylines; i++ )
   {
      _move( 2*w, i * ystep + w );
      _draw( _xmax + 2*w, i * ystep + w );
   }
   penColor( _traceColor );
}

void CroPix::drawTicks ()
{
   int i;
   penColor( _gridColor );

   float xstep = float(_xmax) / _xticks;
   float ystep = float(_ymax) / _yticks;

   // Vertical ticks
   for ( i = 0; i <= _xticks; i++ )
   {
      _move( i * xstep + 2*w, _ymax + 1.5 * w );
      _draw( i * xstep + 2*w, _ymax + w );
   }

   // Horizontal ticks
   for ( i = 0; i <= _yticks; i++ )
   {
      _move( 1.5*w, i * ystep + w );
      _draw( 2*w, i * ystep + w );
   }

   drawLabel();
   penColor( _traceColor );
}

void CroPix::drawLabel ()
{
   bkColor( _windowColor );
   textColor( _gridColor );
   _textFont( "Arial", -10 );
   textBold();

   // x-labels
   rightArrow( *this, _xmax + 2.5*w, _ymax + 2*w + 3, _gridColor );
   textAlign( TA_RIGHT | TA_BOTTOM );
   _text( _xmax + 2*w - 2 , _ymax + 3*w - 2 ) << _xunit;

   // y-labels
   upArrow( *this, 5, 3, _gridColor );
   textAlign( TA_RIGHT | TA_BOTTOM );
   textRotate( 900 );
   _text( w , w + 2 ) << _yunit;
}

void CroPix::leftArrow ( CPWindow & w, int x, int y, CPColor color )
{
   CPColor oldColor = w.penColor( color );
   CPColor oldFillColor = w.fillColor( color );
   w._fillXY( x+1, y );
   w._move( x, y );       // left point
   w._draw( x+7, y-5 );   // top point
   w._draw( x+7, y+5 );   // bottom point
   w._draw( x, y );
   w.fillOff();
   w.penColor( oldColor );
   w.fillColor( oldFillColor );
}

void CroPix::rightArrow ( CPWindow & w, int x, int y, CPColor color )
{
   CPColor oldColor = w.penColor( color );
   CPColor oldFillColor = w.fillColor( color );
   w._fillXY( x-1, y );
   w._move( x, y );       // right point
   w._draw( x-7, y-5 );   // top point
   w._draw( x-7, y+5 );   // bootom
   w._draw( x, y );
   w.fillOff();
   w.penColor( oldColor );
   w.fillColor( oldFillColor );
}

void CroPix::upArrow ( CPWindow & w, int x, int y, CPColor color )
{
   CPColor oldColor = w.penColor( color );
   CPColor oldFillColor = w.fillColor( color );
   w._fillXY( x, y+1 );
   w._move( x, y );       // top point
   w._draw( x-5, y+7 );   // left point
   w._draw( x+5, y+7 );   // right point
   w._draw( x, y );
   w.fillOff();
   w.penColor( oldColor );
   w.fillColor( oldFillColor );
}

void CroPix::downArrow ( CPWindow & w, int x, int y, CPColor color )
{
   CPColor oldColor = w.penColor( color );
   CPColor oldFillColor = w.fillColor( color );
   w._fillXY( x, y-1 );
   w._move( x, y );       // bottom point
   w._draw( x-5, y-7 );   // left point
   w._draw( x+5, y-7 );   // right point
   w._draw( x, y );
   w.fillOff();
   w.penColor( oldColor );
   w.fillColor( oldFillColor );
}

void CroPix::showTrace ( unsigned char dataAry[], unsigned nbSamples )
{
   unsigned n;
   CPDisableYield yield;
   freeze();

   switch ( _traceType )
   {
      case lines:
         penColor( _windowColor );
         for ( n = 0; n < nbSamples; n++ )
         {
            if ( n == 0 )
               _move( 2*w, oldAry[0] + w );
            _draw( n + 2*w, oldAry[n] + w );
         }

         penColor( _traceColor );
         for ( n = 0; n < nbSamples; n++ )
         {
            oldAry[n] = dataAry[n];
            if ( n == 0 )
               _move( 2*w, dataAry[0] + w );
            _draw( n + 2*w, dataAry[n] + w );
         }
         break;

      case sticks:
         penColor( _windowColor );
         for ( n = 0; n < nbSamples; n++ )
         {
            _move( n + 2*w, _ymax + w );
            _draw( n + 2*w, oldAry[n] + w );
         }

         penColor( _traceColor );
         for ( n = 0; n < nbSamples; n++ )
         {
            oldAry[n] = dataAry[n];
            _move( n + 2*w, _ymax + w );
            _draw( n + 2*w, dataAry[n] + w );
         }
         break;
   }
   drawGrid();
   redraw();
}


void CroPix::showTraceFloat ( float * dataAry, unsigned nbSamples )
{
   unsigned n;
   CPDisableYield yield;
   freeze();

   switch ( _traceType )
   {
      case lines:
         penColor( _windowColor );
         for ( n = 0; n < nbSamples; n++ )
         {
            if ( n == 0 )
               _move( 2*w, (unsigned char)oldFloatAry[0] + w );
            _draw( n + 2*w, (unsigned char)oldFloatAry[n] + w );
         }

         penColor( _traceColor );
         for ( n = 0; n < nbSamples; n++ )
         {
            oldFloatAry[n] = dataAry[n];
            if ( n == 0 )
               _move( 2*w, (unsigned char)dataAry[0] + w );
            _draw( n + 2*w, (unsigned char)dataAry[n] + w );
         }
         break;

      case sticks:
         penColor( _windowColor );
         for ( n = 0; n < nbSamples; n++ )
         {
            _move( n + 2*w, _ymax + w );
            _draw( n + 2*w, (unsigned char)oldFloatAry[n] + w );
         }

         penColor( _traceColor );
         for ( n = 0; n < nbSamples; n++ )
         {
            oldFloatAry[n] = dataAry[n];
            _move( n + 2*w, _ymax + w );
            _draw( n + 2*w, (unsigned char)dataAry[n] + w );
         }
         break;
   }
   drawGrid();
   redraw();
}

