// CPAUDIO.H

#include <champ.h>
#include <cparray.h>
#include <mmsystem.h>

#if !defined(__CPAUDIO_H)      // Include only if not yet included
#define __CPAUDIO_H

// #define DEBUG

class CPAudio : public CPWindowHandler
{
public:
   CPAudio ( long samplingRate, long samplingTime, CPWindow & wnd );
   ~CPAudio ();

   void startRecording ( bool continuous = false );
   CPHugeArrayChar aryData;  // Public for rapid access
   bool isRecording () { CP::yield(); return _isRecording; }
   void stopRecording ();
   long CPAudio::getPosition ();

   protected:
      virtual bool wantMsg( UINT uMsg );
      virtual bool evMsg ( CPWindowBase * pWBase, UINT uMsg, WPARAM wParam, 
                           LPARAM lParam, LRESULT & lResult );
  private:
   void stopEventProc ();
#ifdef DEBUG
   void inline debug ( const char * msg ) { cout << msg << endl; }
#else
   void inline debug ( const char * msg ) {}
#endif

   CPHugeArrayChar aryHdr;
   unsigned _rc;
   PCMWAVEFORMAT _pcmWaveFormat;
   HWAVEIN _waveIn;
   char _buf[128] ;
   LPWAVEHDR _waveHdr ;
   HWAVEOUT _waveOut ;
   DWORD _bytesRecorded;
   long _nbSamples;
   long _samplingFreq;
   long _samplingTime;
   bool _isRecording;
   bool _restart;
   int _streamNb;
   DWORD _wndHwnd;
   CPWindow & _wnd;
   MMTIME _mmTime;
};

#endif  // __CPAUDIO



