// CPAUDIO.CPP

#include <champ.h>
#include <process.h>
#include <string.h>
#include <stdlib.h>
#include <mmsystem.h>   // Must be included after champ.h
#include "cpaudio.h"

// The recording should stop immediately when we reach the _nbSamples
// But we get back recording positions slightely above this limit on fast computers...

#define GLITCH 5000  // Security, because getPosition may get larger values than exspected

#define CALLAPIQUIT(a, b)   if ( ( _rc = (a) ) != 0  ) \
{ waveInGetErrorText( _rc, _buf, 128 ); \
CP::msgBox( (b), MB_OK, _buf );  exit( 0 ); }

#define CALLAPI(a, b)   if ( ( _rc = (a) ) != 0  ) \
{ waveInGetErrorText( _rc, _buf, 128 );  \
CP::msgBox( (b), MB_OK, _buf );  }

CPAudio::CPAudio ( long samplingFreq, long samplingTime, CPWindow & wnd )
   :  _nbSamples( samplingTime * samplingFreq / 1000  ),
      aryData( samplingTime * samplingFreq / 1000 + GLITCH ),
      aryHdr( sizeof( WAVEHDR ) ),
      _wnd( wnd )
{
   _waveHdr = (LPWAVEHDR)(LPSTR)aryHdr;
   _waveIn = NULL;
   _bytesRecorded = 0;
   _samplingFreq = samplingFreq;
   _samplingTime = samplingTime;
   _isRecording = false;
   _restart = false;
   _streamNb = 0;

   // Attention: we must cast the wnd.hwnd() to 16 bit and recast to DWORD!!!!
   _wndHwnd = (DWORD)(UINT)wnd.hwnd();

   _pcmWaveFormat.wf.wFormatTag = WAVE_FORMAT_PCM;
   _pcmWaveFormat.wf.nChannels = 1;
   _pcmWaveFormat.wf.nSamplesPerSec = _samplingFreq;
   _pcmWaveFormat.wf.nAvgBytesPerSec = _samplingFreq;
   _pcmWaveFormat.wf.nBlockAlign = 1 ;
   _pcmWaveFormat.wBitsPerSample = 8 ;  // note!!

   _waveHdr->lpData = (LPSTR)aryData;
   _waveHdr->dwBufferLength = (DWORD)_nbSamples;

   CALLAPIQUIT ( waveInOpen( &_waveIn, 0, (LPWAVEFORMAT)&_pcmWaveFormat,
                        _wndHwnd, NULL, CALLBACK_WINDOW ), "waveInOpen" );

   CALLAPI( waveInPrepareHeader( _waveIn, _waveHdr, sizeof( WAVEHDR ) ), "waveInPrepareHeader" );
}

CPAudio::~CPAudio ()
{
   CALLAPI( waveInReset( _waveIn ), "waveInReset" );
   CALLAPI( waveInUnprepareHeader( _waveIn, _waveHdr, sizeof( WAVEHDR ) ), "waveInUnprepareHeader" );
   CALLAPI( waveInClose( _waveIn ), "waveInClose" );
}

void CPAudio::startRecording ( bool continuous )
{
   debug( "startRecording called." );
   _isRecording = true;

   if ( continuous )
   {
      char buf[40];
      char strNb[20];
      _streamNb++;
      itoa( _streamNb, strNb, 10 );
      strcpy( buf, "Stream # " );
      strcat( buf, strNb );
      _wnd.setTitle( buf );
      _restart = true;
   }
   else
      _restart = false;

   CALLAPI( waveInAddBuffer( _waveIn, _waveHdr, sizeof( WAVEHDR ) ), "waveInAddBuffer" );
   debug( "waveInAddBuffer called." );
   CALLAPI( waveInStart( _waveIn ), "waveInStart" );
   debug( "waveInStart called." );
}

void CPAudio::stopEventProc ()
{
   debug( "stopEventProc called." );
   CALLAPI( waveInReset( _waveIn ), "waveInReset" );  //
   _bytesRecorded = _waveHdr->dwBytesRecorded;

   if ( _restart )
     startRecording( true );
   else
     _isRecording = false;
}

void CPAudio::stopRecording ()
{
   if ( !_isRecording )
      return;
   _restart = false;
   _streamNb = 0;
   CALLAPI( waveInStop( _waveIn ), "waveInStop" );
   // Will trigger stopEvent
}

bool CPAudio::wantMsg ( UINT uMsg )
{
   if ( uMsg == MM_WIM_DATA )
   {
      return true;
   }
   return false;
}

#pragma argsused
bool CPAudio::evMsg ( CPWindowBase * pWBase, UINT uMsg, WPARAM wParam, 
                           LPARAM lParam, LRESULT & lResult )
{
   debug( "Got event MM_WIN_DATA" );
   stopEventProc();
   debug( "Event MM_WIN_DATA processed." );
   return true;       // Don't pass the message to Windows
}

long CPAudio::getPosition ()
{
   _mmTime.wType = TIME_SAMPLES;
   waveInGetPosition( _waveIn, &_mmTime, sizeof( MMTIME ) );
   return _mmTime.u.sample;
}

